﻿using System;
using System.Data;

public class PatientImageDetail
{
    public int Id { get; }
    public int PatientId { get; }
    public int? ImageFragmentCountId { get; }
    public int? ImageTypeId { get; }

    public decimal? LargestFragmentLength { get; }
    public decimal? LargestFragmentWidth { get; }
    public decimal? SmallestFragmentLength { get; }
    public decimal? SmallestFragmentWidth { get; }

    public DateTime DateImaged { get; }

    public bool? FragmentVerified { get; }
    public bool? SystemIdentified { get; }
    public bool? Reviewed { get; }
    public bool? IncludeInReport { get; }
    
    public string StudyId { get; }
    public string StudyDescription { get; }
    public string ImageUrl { get; }
    public string Comments { get; }
    public string ImageReasonOtherText { get; }
    public string ImageTypeOtherText { get; }

    public PatientImageDetail(DataRow dr)
    {
        Id = dr.Field<int>("PATIENT_IMAGE_ID");
        PatientId = dr.Field<int>("PATIENT_ID");
        ImageFragmentCountId = dr.Field<int?>("STD_IMAGE_FRAGMENT_COUNT_ID");
        ImageTypeId = dr.Field<int?>("STD_IMAGE_TYPE_ID");

        LargestFragmentLength = dr.Field<decimal?>("LARGEST_FRAGMENT_LENGTH");
        LargestFragmentWidth = dr.Field<decimal?>("LARGEST_FRAGMENT_WIDTH");
        SmallestFragmentLength = dr.Field<decimal?>("SMALLEST_FRAGMENT_LENGTH");
        SmallestFragmentWidth = dr.Field<decimal?>("SMALLEST_FRAGMENT_WIDTH");

        DateImaged = dr.Field<DateTime>("DATE_IMAGED");

        FragmentVerified = dr.Field<bool?>("FRAGMENT_VERIFIED_FLAG");
        SystemIdentified = dr.Field<bool?>("SYSTEM_IDENTIFIED_FRAGMENT_FLAG");
        Reviewed = dr.Field<bool?>("REVIEWED_FLAG");
        IncludeInReport = dr.Field<bool?>("INCLUDE_IN_REPORT_FLAG");

        StudyId = dr.Field<string>("STUDY_ID");
        StudyDescription = dr.Field<string>("STUDY_DESCRIPTION");
        ImageUrl = dr.Field<string>("IMAGE_URL");
        Comments = dr.Field<string>("COMMENTS");
        ImageReasonOtherText = dr.Field<string>("IMAGE_REASON_OTHER_TEXT");
        ImageTypeOtherText = dr.Field<string>("IMAGE_TYPE_OTHER_TEXT");
    }

    public PatientImageDetail(object[] parameters)
    {
        Id = Convert.ToInt32(parameters[0]);
        ImageFragmentCountId = parameters[8] != null ? Convert.ToInt32(parameters[8]) : (int?)null;
        ImageTypeId = parameters[9] != null ? Convert.ToInt32(parameters[9]) : (int?)null;

        FragmentVerified = parameters[1] != null ? Convert.ToBoolean(parameters[1]) : (bool?)null;
        Reviewed = parameters[2] != null ? Convert.ToBoolean(parameters[2]) : (bool?)null;
        IncludeInReport = parameters[3] != null ? Convert.ToBoolean(parameters[3]) : (bool?)null;

        Comments = parameters[10] != null ? Convert.ToString(parameters[10]) : null;

        LargestFragmentLength = parameters[4] != null ? Convert.ToDecimal(parameters[4]) : (decimal?)null;
        LargestFragmentWidth = parameters[5] != null ? Convert.ToDecimal(parameters[5]) : (decimal?)null;
        SmallestFragmentLength = parameters[6] != null ? Convert.ToDecimal(parameters[6]) : (decimal?)null;
        SmallestFragmentWidth = parameters[7] != null ? Convert.ToDecimal(parameters[7]) : (decimal?)null;

        ImageReasonOtherText = parameters[11] != null ? Convert.ToString(parameters[11]) : null;
        ImageTypeOtherText = parameters[12] != null ? Convert.ToString(parameters[12]) : null;
    }
}